#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//autogen 92Mod01.fsh  by   asynth
//https://www.shadertoy.com/view/ftVyzR
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract



vec3 bi(vec3 x) { return 2. * x - 1.; }
vec3 uni(vec3 x) { return 0.5 + 0.5 * x; }

float tri(float x) { // triangle wave
    float p = fract(x * .25 + .25) * 2. - 1.;
    return 1. - 2.0 * abs(p);
}
vec3 tri(vec3 x) { // triangle wave
    vec3 p = fract(x * .25 + .25) * vec3(2.) - vec3(1.);
    return vec3(1.) - vec3(2.0) * abs(p);
}

vec3 well(vec3 x) { // a function that dips in the middle
    return 1. - 2. / pow(1. + x*x, vec3(8.));
}

float quant(float a, float b) {
    return abs(b) < 1e5 ? a : floor(a/b) * b;
}

vec2 quant(vec2 a, vec2 b) {
    return vec2(
        abs(b.x) < 1e5 ? a.x : floor(a.x/b.x) * b.x,
        abs(b.y) < 1e5 ? a.y : floor(a.y/b.y) * b.y
    );
}

vec3 quant(vec3 a, vec3 b) {
    return vec3(
        abs(b.x) < 1e5 ? a.x : floor(a.x/b.x) * b.x,
        abs(b.y) < 1e5 ? a.y : floor(a.y/b.y) * b.y,
        abs(b.z) < 1e5 ? a.z : floor(a.z/b.z) * b.z
    );
}

vec3 sq(vec3 a) {
    return a*a;
}

float sq(float a) {
    return a*a;
}

vec3 sigmoid(vec3 a) {
    return a / sqrt(1.0 + sq(a));
}

vec2 circ_inv(vec2 uv, vec2 center, float radius) {
    float d = distance(uv, center);
    if (d < radius) {
        return uv;
    } else {
        float scale = sq(radius / d);
        return (uv - center) * scale + center;
    }
}


vec3 pthresh(float thresh, vec3 a, vec3 b, vec3 c) {
    return vec3(
        a.x < thresh ? b.x : c.x,
        a.y < thresh ? b.y : c.y,
        a.z < thresh ? b.z : c.z
    );
}

vec2 xywarp(vec2 uv, vec2 a, vec2 b) {
    return vec2(
        uv.x + a.x * b.x,
        uv.y + a.y * b.y
    );
}

vec3 mix2(vec2 uv, vec3 a, vec3 b, vec3 c, vec3 d) {
    return mix(mix(a, b, uv.xxx), mix(c, d, uv.xxx), uv.yyy);
}

vec2 mix2(vec2 uv, vec2 a, vec2 b, vec2 c, vec2 d) {
    return mix(mix(a, b, uv.xx), mix(c, d, uv.xx), uv.yy);
}

float mix2(vec2 uv, float a, float b, float c, float d) {
    return mix(mix(a, b, uv.x), mix(c, d, uv.x), uv.y);
}

float hash12(vec2 p)
{
    vec3 p3  = fract(p.xyx * .1031);
    p3 += dot(p3, p3.yzx + 33.33);
    return fract((p3.x + p3.y) * p3.z);
}

vec3 noise(vec2 uv, vec2 period, float seed) {
    vec2 quv = floor(uv / period) + seed;
    vec2 fuv = mod(uv, period) / period;
    float a = hash12(quv);
    float b = hash12(quv + vec2(1.,0.));
    float c = hash12(quv + vec2(0., 1.));
    float d = hash12(quv + vec2(1.,1.));
    
    return vec3(mix2(smoothstep(0.,1.,fuv), a, b, c, d));
} 

vec2 reflect_0(vec2 uv) { return vec2(uv.x, abs(uv.y)); }
vec2 reflect_1(vec2 uv) { return vec2(abs(uv.x), uv.y); }
vec2 reflect_2(vec2 uv) { return vec2(abs(uv.x), abs(uv.y)); }
vec2 reflect_3(vec2 uv) { return uv.x > -uv.y ? uv : vec2(uv.y, uv.x); }
vec2 reflect_4(vec2 uv) { return uv.x > uv.y ? uv : vec2(uv.y, uv.x); }

vec2 repeat_0(vec2 uv, float q) { return vec2(quant(uv.x, q), uv.y); }
vec2 repeat_1(vec2 uv, float q) { return vec2(uv.x, quant(uv.y, q)); }
vec2 repeat_2(vec2 uv, float q) { return vec2(quant(uv.x, q), quant(uv.y, q)); }
vec2 repeat_3(vec2 uv, float q) { return vec2(tri(uv.x / q) * q, uv.y); }
vec2 repeat_4(vec2 uv, float q) { return vec2(uv.x, tri(uv.y / q) * q); }
vec2 repeat_5(vec2 uv, float q) { return vec2(tri(uv.x / q) * q, tri(uv.y / q) * q); }

vec2 rect_to_polar(vec2 uv) { return vec2(length(uv), atan(uv.y, uv.x)/1.570796); }
vec2 polar_to_rect(vec2 uv) { float angle = uv.y*1.570796; return vec2(uv.x * cos(angle), uv.x * sin(angle)); }

vec3 node_1(vec2 uv) {
	uv = (mat2(0.9327,0.9018,0.8401,1.4059)*(uv-vec2(-0.8121,-0.9407)));
	vec3 a1 = vec3(0.7837, 0.7313, 0.2687);
	return max(vec3(uv.y), a1);
}

vec3 node_2(vec2 uv) {
	vec3 a1 = noise(uv, vec2(3.942471, 0.3522816), 0.626646);
	vec3 a2 = mix2(uv, vec3(0.9468, 0.6824, 0.0192), vec3(0.7940, 0.4222, 0.8684), vec3(0.4639, 0.3296, 0.7163), vec3(0.8814, 0.9856, 0.1783));
	uv = xywarp(uv, vec2(0.6194, -0.1803), min(a1, a2).xy);
	return vec3(uv.x);
}

vec3 node_3(vec2 uv) {
	vec3 a1 = mix2(uv, vec3(0.6947, 0.3704, 0.8683), vec3(0.8626, 0.9462, 0.9314), vec3(0.8893, 0.1959, 0.0705), vec3(0.7779, 0.9979, 0.9341));
	uv = xywarp(uv, vec2(0.7020, -0.6046), a1.xy);
	return vec3(uv.y);
}

vec3 node_4(vec2 uv) {
	uv = repeat_5(uv, 0.6074);
	vec3 a1 = vec3(0.8028, 0.7677, 0.0689);
	vec3 a2 = mix2(uv, vec3(0.5729, 0.7347, 0.0609), vec3(0.9028, 0.2576, 0.3106), vec3(0.3791, 0.7578, 0.7395), vec3(0.9667, 0.3485, 0.0184));
	vec3 a3 = tri(min(a1, a2)*3.0003 + 0.9300 + iTime*0.2834);
	vec3 a4 = mix2(uv, vec3(0.5400, 0.2998, 0.7973), vec3(0.8460, 0.6820, 0.2371), vec3(0.8530, 0.0535, 0.6844), vec3(0.8089, 0.0917, 0.0113));
	return uni((quant(a3, node_2(uv)) * sq(quant(mod(vec3(length(uv)), a4), node_3(uv)))));
}

vec3 node_5(vec2 uv) {
	uv = repeat_4(uv, 0.6935);
	return vec3(uv.x);
}

vec3 node_6(vec2 uv) {
	uv = xywarp(uv, vec2(-0.9645, 0.4145), vec3(uv.y).xy);
	return sigmoid(vec3(length(uv)));
}

vec3 node_7(vec2 uv) {
	uv = repeat_4(uv, 0.2156);
	return sigmoid(vec3(uv.y));
}

vec3 node_8(vec2 uv) {
	uv = (mat2(1.3241,-0.9319,-1.3654,-0.8047)*(uv-vec2(-0.8945,0.5299)));
	return quant(node_7(uv), vec3(uv.y));
}

vec3 node_9(vec2 uv) {
	uv = (mat2(-0.7723,-0.9645,1.2367,1.2732)*(uv-vec2(-0.3859,0.3379)));
	vec3 a1 = noise(uv, vec2(0.9613213, 0.6963149), 0.744056);
	return quant(a1, vec3(length(uv)));
}

vec3 node_10(vec2 uv) {
	uv = repeat_0(uv, 0.1495);
	return node_9(uv);
}

vec3 node_11(vec2 uv) {
	uv = xywarp(uv, vec2(-0.7446, -0.3889), vec3(uv.x).xy);
	vec3 b1 = vec3(0.7737, 0.6231, 0.4825);
	return b1;
}

vec3 node_12(vec2 uv) {
	uv = repeat_3(uv, 0.7979);
	vec3 a1 = mix2(uv, vec3(0.3972, 0.9845, 0.4887), vec3(0.4810, 0.6016, 0.7618), vec3(0.4131, 0.1218, 0.5323), vec3(0.8044, 0.6130, 0.2417));
	vec3 a2 = sin(node_10(uv)*1.9906 + 0.5136 + iTime*0.2858);
	vec3 a3 = tri(quant(vec3(length(uv)), vec3(uv.x))*5.5297 + 0.6049 + iTime*0.2928);
	return min((max(uni((node_6(uv) * node_8(uv))), mod(a1, vec3(uv.y))) * sq(a2)), pthresh(0.4629, node_11(uv), vec3(length(uv)), a3));
}

vec3 node_13(vec2 uv) {
	uv = (mat2(-1.3992,0.9716,1.1755,-1.0493)*(uv-vec2(-0.8413,0.7369)));
	vec3 a1 = mix2(uv, vec3(0.9681, 0.0636, 0.1769), vec3(0.8746, 0.7264, 0.0903), vec3(0.0319, 0.5566, 0.7893), vec3(0.8602, 0.2092, 0.6608));
	vec3 a2 = mix2(uv, vec3(0.8711, 0.1228, 0.4250), vec3(0.4730, 0.0092, 0.5874), vec3(0.4678, 0.3498, 0.3844), vec3(0.8883, 0.4505, 0.9806));
	vec3 a3 = vec3(0.7861, 0.0385, 0.3138);
	vec3 a4 = well(mix(a1, a2, a3)*3.3463 + 0.2894 + iTime*0.3135);
	return min(a4, (-node_12(uv)));
}

vec3 node_14(vec2 uv) {
	uv = (mat2(1.1955,1.0006,0.7823,1.3544)*(uv-vec2(-0.2328,0.1017)));
	vec3 a1 = noise(uv, vec2(0.17702088, 0.8650182), 0.242773);
	return abs(sq(quant(a1, abs(vec3(length(uv))))));
}

vec3 node_15(vec2 uv) {
	vec3 a1 = mix2(uv, vec3(0.8654, 0.9482, 0.1132), vec3(0.8266, 0.5433, 0.2405), vec3(0.1320, 0.8775, 0.4014), vec3(0.2128, 0.1279, 0.0540));
	uv = xywarp(uv, vec2(-0.5817, -0.5070), a1.xy);
	return node_14(uv);
}

vec3 node_16(vec2 uv) {
	uv = repeat_5(uv, 0.1823);
	vec3 a1 = tri(vec3(uv.y)*1.3460 + 0.0160 + iTime*0.0899);
	vec3 a2 = vec3(0.0587, 0.1724, 0.8474);
	return uni(sq(max(min(a1, a2), sigmoid(node_15(uv)))));
}

vec3 node_17(vec2 uv) {
	uv = xywarp(uv, vec2(0.1557, 0.0228), vec3(uv.y).xy);
	return vec3(uv.x);
}

vec3 node_18(vec2 uv) {
	uv = repeat_5(uv, 0.4209);
	vec3 a1 = mix2(uv, vec3(0.2055, 0.8415, 0.9446), vec3(0.7742, 0.6834, 0.9880), vec3(0.8568, 0.9046, 0.5746), vec3(0.1749, 0.5680, 0.5931));
	vec3 a2 = well(pthresh(0.9332, node_4(uv), vec3(uv.y), vec3(uv.y))*2.0510 + 0.7971 + iTime*0.1299);
	vec3 a3 = mix2(uv, vec3(0.9246, 0.0605, 0.1975), vec3(0.1150, 0.9092, 0.0906), vec3(0.7090, 0.7985, 0.7194), vec3(0.5048, 0.3463, 0.0716));
	vec3 a4 = sin(vec3(length(uv))*3.6912 + 0.7637 + iTime*0.1666);
	vec3 a5 = sin(min(sigmoid(mix(a2, sigmoid(node_5(uv)), bi(abs(a3)))), (bi(a4) - node_13(uv)))*2.0501 + 0.1973 + iTime*0.2231);
	vec3 a6 = noise(uv, vec2(0.12340635, 0.18091652), 0.886908);
	vec3 a7 = tri(bi(a6)*2.0636 + 0.6269 + iTime*0.3653);
	vec3 a8 = well(sigmoid(a7)*5.2788 + 0.6440 + iTime*0.2684);
	vec3 a9 = noise(uv, vec2(2.6166272, 3.0778759), 0.472864);
	vec3 a10 = well(sigmoid(a9)*4.1138 + 0.9212 + iTime*0.2269);
	vec3 a11 = sin(bi(node_17(uv))*3.0762 + 0.1346 + iTime*0.2960);
	vec3 a12 = mix2(uv, vec3(0.5322, 0.7749, 0.4663), vec3(0.1928, 0.7898, 0.6772), vec3(0.0481, 0.4236, 0.2043), vec3(0.2678, 0.7932, 0.4567));
	return mod(max(quant(quant(sq((sigmoid(vec3(uv.y)) - node_1(uv))), a1), a5), a8), mod(min(max(a10, max(vec3(length(uv)), vec3(uv.x))), sq(node_16(uv))), (-(a11 - min(sq(a12), vec3(uv.y))))));
}

vec3 node_19(vec2 uv) {
	uv = (mat2(-1.2626,-1.1872,0.9047,1.3633)*(uv-vec2(-0.6615,0.6056)));
	vec3 a1 = mix2(uv, vec3(0.6920, 0.4305, 0.0085), vec3(0.4132, 0.2080, 0.7666), vec3(0.3546, 0.3550, 0.4528), vec3(0.1164, 0.4572, 0.3375));
	return a1;
}

vec3 node_20(vec2 uv) {
	uv = xywarp(uv, vec2(-0.3106, 0.0598), node_19(uv).xy);
	vec3 b1 = tri(vec3(uv.x)*1.9676 + 0.4992 + iTime*0.2251);
	vec3 b2 = mix2(uv, vec3(0.6632, 0.8935, 0.3417), vec3(0.0070, 0.8003, 0.6538), vec3(0.1196, 0.5170, 0.7719), vec3(0.9928, 0.3609, 0.4720));
	vec3 b3 = noise(uv, vec2(1.8175515, 0.9203189), 0.372253);
	return min(b1, (bi(abs(b2)) * max(vec3(uv.y), b3)));
}

vec3 node_21(vec2 uv) {
	uv = (mat2(1.0820,0.7982,0.9664,1.2722)*(uv-vec2(-0.7754,-0.7914)));
	vec3 a1 = vec3(0.3442, 0.4542, 0.0733);
	vec3 a2 = vec3(0.8084, 0.4972, 0.6789);
	return (-quant(a1, a2));
}

vec3 node_22(vec2 uv) {
	uv = (mat2(-0.9788,-0.9569,-1.0823,1.0648)*(uv-vec2(0.0964,-0.6404)));
	vec3 a1 = mix2(uv, vec3(0.1427, 0.9003, 0.2841), vec3(0.6696, 0.7678, 0.3473), vec3(0.6368, 0.2433, 0.2843), vec3(0.3472, 0.0902, 0.8601));
	return a1;
}

vec3 node_23(vec2 uv) {
	uv = repeat_0(uv, 0.6247);
	vec3 a1 = sin(node_22(uv)*2.1253 + 0.0895 + iTime*0.1064);
	vec3 a2 = vec3(0.3541, 0.6583, 0.3357);
	vec3 a3 = sin(a2*3.1191 + 0.5093 + iTime*0.0527);
	vec3 a4 = vec3(0.9493, 0.2375, 0.1921);
	return (vec3(uv.y) * uni(pthresh(0.4669, max(vec3(length(uv)), a1), a3, a4)));
}

vec3 node_24(vec2 uv) {
	uv = xywarp(uv, vec2(-0.7191, -0.9397), node_21(uv).xy);
	vec3 b1 = tri(node_23(uv)*4.3117 + 0.3862 + iTime*0.0924);
	return b1;
}

vec3 node_25(vec2 uv) {
	uv = repeat_3(uv, 0.4516);
	vec3 a1 = vec3(0.6677, 0.1384, 0.1661);
	vec3 a2 = noise(uv, vec2(2.1781807, 1.1180105), 0.816762);
	vec3 a3 = well(vec3(uv.y)*1.4023 + 0.6162 + iTime*0.2816);
	return abs((sigmoid(node_18(uv)) * pthresh(0.0806, uni(pthresh(0.3089, pthresh(0.7921, a1, a2, vec3(uv.x)), a3, vec3(uv.y))), node_20(uv), abs((-bi(node_24(uv)))))));
}

vec3 top(vec2 uv) {
	return node_25(uv);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = (2.*fragCoord-iResolution.xy)/iResolution.y;
    vec3 col = abs(sin(top(uv)));
    fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

